import 'package:flutter_secure_storage/flutter_secure_storage.dart';

class SecureStorage {
  static final FlutterSecureStorage _storage = _initStorage();
  static Future<String?> read(String key) async {
    return await _storage.read(key: key);
  }

  static Future<void> write(String key, String? value) async {
    await _storage.write(key: key, value: value);
  }

  static FlutterSecureStorage _initStorage() {
    AndroidOptions getAndroidOptions() =>
        const AndroidOptions(encryptedSharedPreferences: true);
    return FlutterSecureStorage(aOptions: getAndroidOptions());
  }
}
